//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;
using VBException;
using PerlWordCount;
using CPPExceptions;

namespace CrossLanguage
{
	/// <summary>
	/// Podsumowanie dla Class1.
	/// </summary>
	class CrossLanguageException
	{
		static void Main(string[] args)
		{
			Console.WriteLine("\nWyjtek VB\n");
			// Zgoszenie wyjtku w VB
			try
			{
				VBExceptionClass vbe = new VBExceptionClass();
				vbe.ExceptionGenerator();
			}
			catch(Exception e)
			{
				Console.WriteLine("Przechwycono wyjtek VB " + e.ToString());
			}

			Console.WriteLine("\nWyjtek VC++\n");
			// Zgoszenie wyjtku w VC++
			try
			{
				CPPExceptionClass vcppe = new CPPExceptionClass();
				vcppe.ExceptionGenerator();
			}
			catch(Exception e)
			{
				Console.WriteLine("Przechwycono wyjtek VC++ " + e.ToString());
			}

			Console.WriteLine("\nWyjtek Perl\n");
			// Teraz sprbujmy uy Perla
			using (WordCount obj = new WordCount()) 
			{
				// Ustawienie waciwoci 'Text'
				obj.Text = "By albo nie by?";

				// Uzyskanie waciwoci 'Text'
				Console.WriteLine("Tekst to '{0}'", obj.Text);

				// Wywoanie 'Count' dla sowa nie znajdujcego si w 'Text' powoduje zgoszenie wyjtku
				try 
				{
					String word = "test";
					Console.WriteLine("{0} pojawia si {1} raza(y)", word, obj.Count(word));
				}
				catch (Exception e) 
				{
					Console.WriteLine(e.ToString());
				}
			}
		}
	}
}
